/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScreenOpener {
    private static final Deque<class_437> backStack = new ArrayDeque<class_437>();

    public static void open(@Nullable class_437 screen) {
        ScreenOpener.open(class_310.method_1551().field_1755, screen);
    }

    public static void open(@Nullable class_437 current, @Nullable class_437 toOpen) {
        if (current != null) {
            if (backStack.size() >= 15) {
                backStack.pollLast();
            }
            backStack.push(current);
        } else {
            backStack.clear();
        }
        ScreenOpener.openScreen(toOpen);
    }

    public static void openPreviousScreen() {
        class_437 previousScreen = backStack.pollFirst();
        if (previousScreen == null) {
            return;
        }
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen previousNavScreen = (NavigatableSimiScreen)previousScreen;
            previousNavScreen.transition.startWithValue(-0.001).chase(-1.0, 0.3f, LerpedFloat.Chaser.EXP);
        }
        ScreenOpener.openScreen(previousScreen);
    }

    public static void transitionTo(NavigatableSimiScreen screen) {
        if (ScreenOpener.tryBackTracking(screen)) {
            return;
        }
        screen.transition.startWithValue(0.001).chase(1.0, 0.3f, LerpedFloat.Chaser.EXP);
        ScreenOpener.open(screen);
    }

    private static boolean tryBackTracking(NavigatableSimiScreen screen) {
        class_437 previouslyRenderedScreen = ScreenOpener.getScreenFirst();
        if (previouslyRenderedScreen == null) {
            return false;
        }
        if (!(previouslyRenderedScreen instanceof NavigatableSimiScreen)) {
            return false;
        }
        NavigatableSimiScreen navigatableSimiScreen = (NavigatableSimiScreen)previouslyRenderedScreen;
        if (!screen.isEquivalentTo(navigatableSimiScreen)) {
            return false;
        }
        screen.shareContextWith(navigatableSimiScreen);
        ScreenOpener.openPreviousScreen();
        return true;
    }

    public static void clearStack() {
        backStack.clear();
    }

    public static List<class_437> getScreenHistory() {
        return new ArrayList<class_437>(backStack);
    }

    @Nullable
    public static class_437 getScreenFirst() {
        return backStack.peekFirst();
    }

    @Nullable
    public static class_437 getBackStepScreen() {
        return backStack.peek();
    }

    private static void openScreen(@Nullable class_437 screen) {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507(screen));
    }
}

